#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

int main(int argc, char *argv[]);

int main(int argc, char *argv[])
{
	FILE		*out;
	int		i,j;
	int		h=480,w=640;
	float		R[h][w];
	float		G[h][w];
	float		B[h][w];
	unsigned char	r,g,b;

  // set up 2D w x h array, all 1.0 (normalized color)
  for(i=0;i<h;i++) {
    for(j=0;j<w;j++) {
      R[i][j] = 1.0;
      G[i][j] = 0.0;
      B[i][j] = 0.0;
    }
  }

  // open output file
  out = fopen("color.ppm","w");
  if(!out) {
     printf("Error in opening output image\n");
     return 1;
  }
  // write output
  fprintf(out,"P6\n%d %d\n255\n",w,h);
  for(i=0;i<h;i++) {
    for(j=0;j<w;j++) {
      r = (unsigned char)(R[i][j]*255.0);
      g = (unsigned char)(G[i][j]*255.0);
      b = (unsigned char)(B[i][j]*255.0);
      fwrite(&r,sizeof(unsigned char),1,out);
      fwrite(&g,sizeof(unsigned char),1,out);
      fwrite(&b,sizeof(unsigned char),1,out);
    }
  }
  fflush(out);

  // close output
  fclose(out);

  return 0;
}
