#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "pgm.h"

PGM	*pgm_alloc(int r, int c)
{
	PGM *img = NULL;

  // allocate struct
  img = (PGM *)malloc(sizeof(PGM));

  if(!img) {
    fprintf(stderr,"WARNING: could not allocate memory for img\n");
  }

  // initialize struct contents
  img->name = NULL;
  img->rows = r;
  img->cols = c;
  img->maxc = 255;
  img->magic = (char *)malloc(3*sizeof(char));
  strcpy(img->magic,"P5");
  img->data = (float *)malloc((r*c)*sizeof(float));

  // if we couldn't allocate room for r*c data
  if(!img->data) {
    fprintf(stderr,"WARNING: could not allocate memory for img data\n");
  }

  return img;
}

void     pgm_free(PGM **img)
{
  // free internals, anything that got allocated
  if((*img)->name)
    free((*img)->name);

  if((*img)->magic)
    free((*img)->magic);

  if((*img)->data)
    free((*img)->data);

  // free (pointer to) struct
  free((*img));
  (*img) = NULL;
}

PGM     *pgm_read(const char *file)
{
	int		i,j;
	int		rows,cols,maxc;
	char		c;
	PGM 		*img = NULL;
	FILE		*in = NULL;
	unsigned char	data;

  // open file
  in = fopen(file,"r");
  if(!in) {
    fprintf(stderr,"Error in opening %s\n", file);
    return img;
  }

  // read input
  if( ((c=fgetc(in))=='P') && ((c=fgetc(in))=='5') && ((c=fgetc(in))=='\n')) {

    // ppm images can have # comments after first line
    if((c=fgetc(in))=='#')
      do {
        c=fgetc(in);
      } while(c!='\n');
    else
      ungetc(c,in);

    // read width, height
    if(fscanf(in,"%u %u",&cols,&rows) < 2)
      fprintf(stderr,"Error getting width, height from %s\n", file);

    // read maxc
    if( (fscanf(in,"%u\n",&maxc) < 1) || maxc != 255 )
      fprintf(stderr,"Error getting maxc from %s\n", file);

    img = pgm_alloc(rows,cols);

    if(img) {
      // read in data
      for(i=0;i<rows;i++) {
        for(j=0;j<cols;j++) {
          if( (fread(&data,sizeof(unsigned char),1,in) < 1) || feof(in) )
            fprintf(stderr,"Error getting r from %s\n", file);

          img->data[i*img->cols + j] = (float)data/(float)maxc;

        }
      }
    }

  } else {
    fprintf(stderr,"Unknown character in %s\n", file);
  }

  return img;
}

int      pgm_write(PGM *img, const char *file)
{
	int		i,j;
 	FILE		*out;
	unsigned char	grey;

  // open output file for writing
  out = fopen(file,"w");
  if(!out) {
    printf("Error in opening %s\n", file);
    return 1;
  }

  // write output
  fprintf(out,"%s\n%d %d\n%d\n",img->magic,img->rows,img->cols,img->maxc);
  for(i=0;i<img->rows;i++) {
    for(j=0;j<img->cols;j++) {
      grey = (unsigned char)(img->data[i*img->cols + j] * (float)img->maxc);
      fwrite(&grey,sizeof(unsigned char),1,out);
    }
  }
  fflush(out);

  fclose(out);

  return 0;
}

void     pgm_white(PGM *img)
{
	int i,j;

  // set image data contents to 1.0 (white)
  for(i=0; i<img->rows; i++) {
    for(j=0; j<img->cols; j++) {
      img->data[i*img->cols + j] = 1.0;
    }
  }
}
