#ifndef PPM_H
#define PPM_H

typedef struct {
	char		*name; 	// filename
	int		cols;	// width
	int		rows;	// height
	int		maxc;	// max color (usually 255)
	char		*magic;	// magic number (expect 'P6')
	float		*rdata;	// red pixels, stored as 1D array
	float		*gdata;	// green pixels, stored as 1D array
	float		*bdata;	// blue pixels, stored as 1D array
} PPM;

PPM	*ppm_alloc(int r, int c);
void     ppm_free(PPM **img);
PPM     *ppm_read(const char *file);
int      ppm_write(PPM *img, const char *file);
void     ppm_white(PPM *img);
PGM     *ppm_togrey(PPM *img);

#endif
