#include <omp.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

int main(int argc, char *argv[]);

int main(int argc, char *argv[])
{
	FILE		*out;
	int		tid,ncores=1,chunk;
	int		i,j;
	int		h=480,w=640;
	float		R[h][w];
	float		G[h][w];
	float		B[h][w];
	unsigned char	r,g,b;

  // set up 2D w x h array, all 1.0 (normalized color)
  for(i=0;i<h;i++) {
    for(j=0;j<w;j++) {
      R[i][j] = 1.0;
      G[i][j] = 0.0;
      B[i][j] = 0.0;
    }
  }

  // figure out how many threads we have available
  #pragma omp parallel private(tid)
  {
    if((tid = omp_get_thread_num())==0)
      ncores = omp_get_num_threads();
  }
  fprintf(stderr,"no. cores: %d\n",ncores);

  // then calculate chunk, splitting up the work as evenly as possible
  chunk = h/ncores;
  fprintf(stderr,"h: %d\n",h);
  fprintf(stderr,"chunk (%d/%d): %d\n",h,ncores,chunk);

  // create image in parallel
  // sets up private/shared memory access, shared means one copy, accessible
  // by all threads concurrently (potential conflict), private means data
  // is copied to all threads
  #pragma omp parallel \
            shared(w,h,R,G,B) \
            private(tid)
  // modifies the first for statement encountered, unrolling it equivalently
  // into number of chunks, each chunk per core
  #pragma omp for schedule(static,chunk) nowait
  for(int y=h-1;y>=0;y--) {
    for(int x=0;x<w;x++) {
      // fake banding
      tid = omp_get_thread_num();
      switch(tid % 7) {
          case 0: R[y][x] = 1.0;  G[y][x] = 0.0;  G[y][x] = 0.0;  break;
          case 1: R[y][x] = 0.0;  G[y][x] = 1.0;  G[y][x] = 0.0;  break;
          case 2: R[y][x] = 0.0;  G[y][x] = 0.0;  G[y][x] = 1.0;  break;
          case 3: R[y][x] = 1.0;  G[y][x] = 1.0;  G[y][x] = 0.0;  break;
          case 4: R[y][x] = 1.0;  G[y][x] = 0.0;  G[y][x] = 1.0;  break;
          case 5: R[y][x] = 0.0;  G[y][x] = 1.0;  G[y][x] = 1.0;  break;
          case 6: R[y][x] = 1.0;  G[y][x] = 1.0;  G[y][x] = 1.0;  break;
         default: R[y][x] = 0.0;  G[y][x] = 0.0;  G[y][x] = 0.0;  break;
      }
    }
  }

  // open output file
  out = fopen("color.ppm","w");
  if(!out) {
     printf("Error in opening output image\n");
     return 1;
  }
  // write output
  fprintf(out,"P6\n%d %d\n255\n",w,h);
  for(i=0;i<h;i++) {
    for(j=0;j<w;j++) {
      r = (unsigned char)(R[i][j]*255.0);
      g = (unsigned char)(G[i][j]*255.0);
      b = (unsigned char)(B[i][j]*255.0);
      fwrite(&r,sizeof(unsigned char),1,out);
      fwrite(&g,sizeof(unsigned char),1,out);
      fwrite(&b,sizeof(unsigned char),1,out);
    }
  }
  fflush(out);

  // close output
  fclose(out);

  return 0;
}
