#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<math.h>

#include	"defs.h"
#include	"arrays.h"


void darr_init(double *darr, int r, int c)
{
  memset(darr,0,r*c*sizeof(double));
}


double *darr_make(int r,int c)
{
	double	*darr;

  if((darr = (double *)malloc(r*c*sizeof(double)))==NULL)
    fprintf(stderr,"darr_make: malloc: %s\n",sys_errlist[errno]);
  return(darr);
}

void darr_normalize(double *darr,int r,int c)
{
        int             i,j;
        double          min,max,denom,nval;

  min = HUGE; max = -HUGE;
  for(i=0;i<r;i++) {
    for(j=0;j<c;j++) {
      if(darr[M2A(i,j,r,c)] > max) max = darr[M2A(i,j,r,c)];
      if(darr[M2A(i,j,r,c)] < min) min = darr[M2A(i,j,r,c)];
    }
  }
  denom = max - min + 1.;
  for(i=0;i<r;i++) {
    for(j=0;j<c;j++) {
      darr[M2A(i,j,r,c)] = (darr[M2A(i,j,r,c)] - min)/denom;
    }
  }
}
