#include	<stdio.h>
#include	<stdlib.h>
#include	<errno.h>
#include	<math.h>

#include	"filters.h"

FLTR *make_filter(int which)
{
	int	i;
	FLTR	*fltrp;

  if((fltrp = (FLTR *)malloc(sizeof(FLTR)))==NULL)
    fprintf(stderr,"make_filter: malloc: %s\n",sys_errlist[errno]);

    fltrp->len = 3;
    if((fltrp->dx = (double *)malloc((fltrp->len)*sizeof(double)))==NULL)
      fprintf(stderr,"make_wavelet: malloc: %s\n",sys_errlist[errno]);
    if((fltrp->dy = (double *)malloc((fltrp->len)*sizeof(double)))==NULL)
      fprintf(stderr,"make_wavelet: malloc: %s\n",sys_errlist[errno]);

    // from: https://fiveko.com/tutorials/image-processing/sobel-filter/

    if(!which) {
      // Gx
      fltrp->dx[0] 	=  1.;
      fltrp->dx[1] 	=  0.;
      fltrp->dx[2] 	= -1.;

      fltrp->dy[0] 	=  1.;
      fltrp->dy[1] 	=  2.;
      fltrp->dy[2] 	=  1.;
   } else {
     // Gy
    fltrp->dx[0] 	=  1.;
    fltrp->dx[1] 	=  2.;
    fltrp->dx[2] 	=  1.;

    fltrp->dy[0] 	=  1.;
    fltrp->dy[1] 	=  0.;
    fltrp->dy[2] 	= -1.;

   }

  return(fltrp);
}

void free_filter(FLTR **fltrp)
{
  if((*fltrp)) {
    free((*fltrp)->dx);
    free((*fltrp)->dy);
    free((*fltrp));
    (*fltrp) = NULL;
  }
}
