#ifndef PGM_H
#define PGM_H

typedef struct {
	char		*name; 	// filename
	int		cols;	// width
	int		rows;	// height
	int		maxc;	// max color (usually 255)
	char		*magic;	// magic number (expect 'P5')
	double		*data;	// the pixels, stored as 1D array
} PGM;

PGM	*pgm_alloc(int r, int c);
PGM     *pgm_read(const char *file);
PGM     *pgm_copy(PGM *img);
void     pgm_free(PGM **img);
int      pgm_write(PGM *img, const char *file);
void     pgm_normalize(PGM *img);
PGM     *pgm_conv(PGM *img,FLTR *fp);

#endif
